(function(exports) {
	var response_lenght = 5;
	var queryTimeout = 1000;

	var data_type_template = {"templates": [
		{"index": "1011_1","template": "restore_params"},
		{"index": "1027_1","template": "combobox", "commands": templates_commands.board_types()},
		{"index": "1027_2","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_3","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_4","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_5","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_6","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_7","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_8","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "1027_9","template": "combobox", "commands": templates_commands.module_types()},
		{"index": "2000_2","template": "ip_addr"},
		{"index": "2000_3","template": "ip_addr"},
		{"index": "2000_6","template": "ip_addr"},
		{"index": "2001_1","template": "change_value", "commands": templates_commands.restart_reason()},
		{"index": "2001_12","template": "change_value", "commands": templates_commands.hw_error_flags()},
		{"index": "2001_13","template": "change_value", "commands": templates_commands.sw_error_flags()},
		{"index": "2002_1","template": "combobox", "commands": templates_commands.access_commands()},
		{"index": "2001_9","template": "change_value", "commands": templates_commands.access_values()},
		{"index": "2002_2","template": "password"},
		{"index": "2081_1","template": "datetime"},
		{"index": "2101_5", "template": "change_value", "commands": templates_commands.CAN_port_status()},
		{"index": "2105_5", "template": "change_value", "commands": templates_commands.CAN_port_status()},
		{"index": "2109_5", "template": "change_value", "commands": templates_commands.CAN_port_status()},
		{"index": "2213_2","template": "ip_addr"},
		{"index": "2213_3","template": "ip_addr"},
		{"index": "2213_4","template": "ip_addr"},
		{"index": "2213_5","template": "ip_addr"},
		{"index": "2213_6","template": "ip_addr"},
		{"index": "2213_1","template": "combobox", "commands": templates_commands.on_off_values()},
		{"index": "2301_1","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_2","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_3","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_4","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_5","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_6","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_7","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2301_8","template": "change_value", "commands": templates_commands.canopen_node_status()},
		{"index": "2343_1","template": "boolean_type"},
		{"index": "3000_5","template": "change_value", "commands": templates_commands.report_flag()},
		{"index": "3001_1","template": "boolean_type"},
		{"index": "3001_3","template": "date"},
		{"index": "5000_2","template": "datetime_simple"},
		{"index": "5000_3","template": "ip_addr"},
		{"index": "5001_1","template": "change_value", "commands": templates_commands.appsw_status()},
		{"index": "5002_1","template": "combobox", "commands": templates_commands.appsw_cmd()},
	]};
// 1003 Error field
	for (var err_field = 1; err_field < 65; err_field++) {
        data_type_template.templates.push({"index": `1003_${err_field}`,"template": "error_field"})
    }
// 1016 Heartbeat Consumer
	for (var subi = 1; subi < 65; subi++) {
        data_type_template.templates.push({"index": `1016_${subi}`,"template": "consumer_heartbeat"})
    }

// RPDO Mapping
	for (var index = 0x1600; index <= 0x163F; index++) {
		for (var subi = 1; subi < 12; subi++) {
			data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "pdo_mapping"})
		}
	}
// TPDO Mapping
	for (var index = 0x1A00; index <= 0x1A7F; index++) {
		for (var subi = 1; subi < 12; subi++) {
			data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "pdo_mapping"})
		}
	}
// Communication (CAN, Serial and Ethernet)
	for (var interface_number = 0; interface_number < 3; interface_number++){
		var eds_index = 0x2143 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": templates_commands.baudrate()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_4`,"template": "combobox", "commands": templates_commands.parity()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_5`,"template": "combobox", "commands": templates_commands.stopbits()})
		var eds_index = 0x2103 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": templates_commands.CAN_speed()})
		var eds_index = 0x2333 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		var eds_index = 0x2383 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		var eds_index = 0x2323 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
	}
	for (var interface_number = 0; interface_number < 3; interface_number++) {
		for (var subi = 1; subi < 64; subi++) {
		    var index = 0x2311 + interface_number*4
    		data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "change_value", "commands": templates_commands.canopen_NMT_status()})
        }
    }
// Modules (boards)
	for (var board_number = 1; board_number < 9; board_number++) {
		var eds_index = 0x3F03 + board_number*0x100
		var template = {"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "restore_params"}
		data_type_template.templates.push(template)
		for (var eds_subindex = 1; eds_subindex < 9; eds_subindex++) {
			var eds_index = 0x3F39 + board_number*0x100
			var template = {"index": `${eds_index.toString(16).toUpperCase()}_${eds_subindex}`,"template": "combobox", "commands": templates_commands.sensor_type_rtd()}
			data_type_template.templates.push(template)
		}
	}
// PM Modules
	for (var board_number = 0; board_number < 8; board_number++) {
		var eds_index = 0x4060 + board_number*0x100
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "combobox", "commands": templates_commands.connection_scheme()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": templates_commands.current_range()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`,"template": "combobox", "commands": templates_commands.current_range()})
    }
// Energy Profiles
	data_type_template.templates.push({"index": "3000_2","template": "datetime_simple"})
	data_type_template.templates.push({"index": "3000_3","template": "datetime_simple"})
	data_type_template.templates.push({"index": "3000_4","template": "datetime_simple"})
//	data_type_template.templates.push({"index": "3001_3","template": "date"})
	for (var board_number = 0; board_number < 8; board_number++) {
      	for (var pm_profile = 0; pm_profile < (160 + 1); pm_profile++) {
            var index = 0x3002 + (board_number * 0x100) + pm_profile
            data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_1`,"template": "datetime_simple"})
		    data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_2`,"template": "datetime_simple"})
		    data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_3`,"template": "hex"})
        }
    }

    const serial_port_number = 3
    const serial_port_requests = 128
    const ports_req_offset = 0x300
    const tcp_port_requests = 256
//RTU Client
	for (var serial_port_i = 0; serial_port_i < serial_port_number; serial_port_i++){
        var port_index = 0x5100 + (ports_req_offset * serial_port_i)
	    for (var request_per_port = 0; request_per_port < serial_port_requests; request_per_port++){
		    var eds_index = port_index + request_per_port*2 // Serial 1
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`, "template": "change_value",  "commands": templates_commands.request_status()})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_11`, "template": "combobox",     "commands": templates_commands.mb_functions()})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_14`, "template": "combobox",     "commands": templates_commands.req_trigger_type()})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_16`, "template": "change_value", "commands": templates_commands.byte_and_word_order()})
            eds_index += 1
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`, "template": "change_value", "commands": templates_commands.data_status()})
        }
    }
//TCP Client
	for (var request_per_port = 0; request_per_port < tcp_port_requests; request_per_port++){
		var eds_index = 0x5A00 + request_per_port*2
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`, "template": "change_value", "commands": templates_commands.request_status()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_10`,"template": "ip_addr"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_15`, "template": "combobox", "commands": templates_commands.mb_functions()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_18`, "template": "combobox", "commands": templates_commands.req_trigger_type()})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_20`, "template": "change_value", "commands": templates_commands.byte_and_word_order()})
        eds_index += 1
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`, "template": "change_value", "commands": templates_commands.data_status()})
    }

	var expert_page_dictionary = [
		{"minIndex" : "0x0001", "maxIndex" : "0x0FFF", "name" : "Data Type Definitions"},
		{"minIndex" : "0x1000", "maxIndex" : "0x1029", "name" : "Communication Parameters"},
		{"minIndex" : "0x1200", "maxIndex" : "0x12FF", "name" : "SDO Parameters"},
		{"minIndex" : "0x1400", "maxIndex" : "0x15FF", "name" : "Receive PDO Parameters"},
		{"minIndex" : "0x1600", "maxIndex" : "0x17FF", "name" : "Receive PDO Mapping"},
		{"minIndex" : "0x1800", "maxIndex" : "0x19FF", "name" : "Transmit PDO Parameters"},
		{"minIndex" : "0x1A00", "maxIndex" : "0x1BFF", "name" : "Transmit PDO Mapping"},
		{"minIndex" : "0x1C00", "maxIndex" : "0x1FFF", "name" : "Other Communication Parameters"},
		//{"minIndex" : "0x2000", "maxIndex" : "0x4FFF", "name" : "Manufacturer Specific"},
		{"minIndex" : "0x2000", "maxIndex" : "0x2FFF", "name" : "General Device Parameters"},
		{"minIndex" : "0x3F00", "maxIndex" : "0x3FFF", "name" : "Module 0"},
		{"minIndex" : "0x4000", "maxIndex" : "0x40FF", "name" : "Module 1"},
		{"minIndex" : "0x4100", "maxIndex" : "0x41FF", "name" : "Module 2"},
		{"minIndex" : "0x4200", "maxIndex" : "0x42FF", "name" : "Module 3"},
		{"minIndex" : "0x4300", "maxIndex" : "0x43FF", "name" : "Module 4"},
		{"minIndex" : "0x4400", "maxIndex" : "0x44FF", "name" : "Module 5"},
		{"minIndex" : "0x4500", "maxIndex" : "0x45FF", "name" : "Module 6"},
		{"minIndex" : "0x4600", "maxIndex" : "0x46FF", "name" : "Module 7"},
		{"minIndex" : "0x4700", "maxIndex" : "0x47FF", "name" : "Module 8"},
		{"minIndex" : "0x4C00", "maxIndex" : "0x4FFF", "name" : "External IO"},
		{"minIndex" : "0x3000", "maxIndex" : "0x3EFF", "name" : "Energy Profiles"},
		{"minIndex" : "0x5100", "maxIndex" : "0x53FF", "name" : "Modbus Serial 1 Client Requests"},
		{"minIndex" : "0x5400", "maxIndex" : "0x56FF", "name" : "Modbus Serial 2 Client Requests"},
		{"minIndex" : "0x5700", "maxIndex" : "0x59FF", "name" : "Modbus Serial 3 Client Requests"},
		{"minIndex" : "0x5A00", "maxIndex" : "0x5FFF", "name" : "Modbus TCP Client Requests"},
		{"minIndex" : "0x6000", "maxIndex" : "0x9FFF", "name" : "Standardized Device Profile"},
		{"minIndex" : "0x5000", "maxIndex" : "0x500F", "name" : "Application SW Parameters"},
		{"minIndex" : "0xA000", "maxIndex" : "0xAFFF", "name" : "Application SW Variables"},
		{"minIndex" : "0xB000", "maxIndex" : "0xBFFF", "name" : "Application SW Profiles"}
	]

	exports.expert_page_dictionary = function() { return expert_page_dictionary;}
	exports.response_lenght = function() { return response_lenght;}
	exports.queryTimeout = function() { return queryTimeout;}
	exports.data_type_template = function() { return data_type_template;}
	//exports.default_checkbox_values = function() { return templates_commands.default_checkbox_values();}
})(this.configuration_expert = {});
